local t = Def.ActorFrame{
	-- the quad
	Def.Quad{
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y+20;zoomto,SCREEN_WIDTH,4;cropright,1;diffuse,color("#000000"));
		OnCommand=cmd(linear,0.75;cropright,0);
		OffCommand=cmd(accelerate,0.5;zoomy,0);
	};
	
	-- the logo
	Def.ActorFrame{
		Name="LogoFrame";
		InitCommand=cmd(x,SCREEN_LEFT+220;y,SCREEN_CENTER_Y-35;horizalign,left);
		
		LoadActor("ssc")..{
			Name="SpinalSharkCollective";
			InitCommand=cmd(addy,-64;diffusealpha,0);
			OnCommand=cmd(decelerate,1.8;diffusealpha,1;addy,64);
		};
		
		LoadActor("dubaiOne")..{
			Name="dubaiOne";
			InitCommand=cmd(diffusealpha,0);
			OnCommand=cmd(sleep,1.8;linear,0.4;diffusealpha,1);
		};
		--[[
		LoadActor("pointOne")..{
			Name="pointOne";
			InitCommand=cmd(diffusealpha,0;horizalign,left;x,204;y,22);
			OnCommand=cmd(sleep,1.8;linear,0.4;diffusealpha,1);
		};
		]]
		LoadFont("_frutiger lt std 55 roman 24px")..{
			--[[ XXX for 1.5 & WS test: make "version" a language metric ]]
			Text="version ".. themeInfo.Version .." (".. themeInfo.Date ..")";
			InitCommand=cmd(x,-192;y,66;zoom,0.55;diffusealpha,0;horizalign,left;shadowlength,0);
			OnCommand=cmd(sleep,1.8;linear,0.4;diffuse,color("0,0,0,1"));
		};
		
		LoadActor("glow")..{
			Name="glow";
			InitCommand=cmd(diffusealpha,0;diffuseshift;effectperiod,2);
			OnCommand=function(self)
				self:sleep(1.8);
				self:linear(0.4);
				self:diffusealpha(1);
				
				if(getenv("Debug")) then
					self:effectcolor1(color("1,1,1,0"));
					self:effectcolor2(color("1,0.9,0.9,1"));
				else
					self:effectcolor1(color("1,1,1,0"));
					self:effectcolor2(color("1,1,1,1"));
				end;
			end;
			SwapMessageCommand=function(self)
				if(getenv("Debug")) then
					self:effectcolor1(color("1,1,1,0"));
					self:effectcolor2(color("1,0.9,0.9,1"));
				else
					self:effectcolor1(color("1,1,1,0"));
					self:effectcolor2(color("1,1,1,1"));
				end;
			end;
		};
	};
	
	-- some junk for April Fool's :D
	LoadActor("_harisu")..{
		InitCommand=cmd(horizalign,left;vertalign,bottom;x,SCREEN_LEFT+12;y,SCREEN_BOTTOM-12;diffusealpha,0);
		OnCommand=function(self)
			if (AprilFools() or getenv("Debug")) then (cmd(visible,true;linear,2;diffusealpha,1))(self)
			else self:visible(false);
			end;
		end;
		OffCommand=cmd(linear,0.2;diffusealpha,0);
		SwapMessageCommand=function(self)
			if(getenv("Debug")) then
				self:linear(0.5);
				self:diffusealpha(1);
			else
				self:linear(0.5);
				self:diffusealpha(0);
			end;
		end;
	};
	
	-- The code for setenv is in Scripts/EnvUtils.lua. Don't expect to just
	-- throw setenv into a theme and have it work.
	LoadFont("_frutiger lt std 55 roman 24px")..{
		Name="CodeDetector";
		Text="";
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_BOTTOM-64;visible,false;shadowlength,0;diffuse,color("#000000"));
		CodeMessageCommand=function(self, params)
			if params.Name == 'Debug' then
				self:diffusealpha(0);
				self:visible(true);
				self:linear(0.5);
				self:diffusealpha(1);
				self:sleep(1);
				self:linear(0.5);
				self:diffusealpha(0);
				
				local text = "Debug Mode ";
				if not getenv("Debug") then
					setenv("Debug",true);
					text = text .. "Enabled";
				else
					setenv("Debug",false);
					text = text .. "Disabled";
				end;
				MESSAGEMAN:Broadcast("Swap");
				self:settext(text);
			end;
		end;
	};
};

return t;